<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $e)
    {
        if ($e instanceof \Illuminate\Database\QueryException) {
            // show custom view
            //Or
            // dump($e->errorInfo[2]);

            echo '<!DOCTYPE html>
            <html lang="en">
            <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>DB Error</title>
            <link rel="preconnect" href="https://fonts.gstatic.com">
            <link href="https://fonts.googleapis.com/css2?family=Nunito&display=swap" rel="stylesheet">
            <style>
                html, body {
                    background-color: #fff;
                    color: #636b6f;
                    font-family: "Nunito", sans-serif;
                    font-weight: 100;
                    height: 100vh;
                    margin: 0;
                }
                .full-height {
                    height: 100vh;
                }
                .flex-center {
                    align-items: center;
                    display: flex;
                    justify-content: center;
                }
                .position-ref {
                    position: relative;
                }
                .content {
                    text-align: center;
                }
                .title {
                    font-size: 36px;
                    padding: 20px;
                }
            </style>
        </head>
            <body><div class="flex-center position-ref full-height">
            <div class="content">
                <div class="title">';
                if (isset($e->errorInfo)) {
                    echo $e->errorInfo[2];
                }
                else {
                    echo 'Error in Database';
                }
            echo '</div></div></div></body></html>';
        }
        return parent::render($request, $e);
    }
}
