<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\BlogCategoryServices;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminBlogCategoryController extends Controller
{

    public $blog_category;
    public function __construct()
    {
        Parent::__construct();
        $blog_category = new BlogCategoryServices();
        $this->blog_category = $blog_category;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
            if(request()->ajax()){
                $get = $this->blog_category->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='javascript:void(0) '>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-id='" . $get->id . "'>" . __('Edit') . "</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.blog.category.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->addColumn('status', function ($get) {
                        $status  = "<label class='switch'>
                            <input type='checkbox' " . ($get->status ? 'checked' : '') . " id='" . $get->id . "' class='teacherActivationBtn'>
                            <span class='slider round'></span>
                        </label>";
                        return $status;
                    })
                    ->rawColumns(['action','status'])->make(true);
            }

            return view('backend.pages.blogs.category', [
                'title' => 'Blog Categories',
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $category = $this->blog_category->store([
                'name' => $request->name
            ]);
            return $this->backWithSuccess($category->name . ' category has been created successfully');
        }catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $category = $this->blog_category->findById($id);
        try{
            $output = '<div class="modal-header">
                    <h5 class="modal-title card-title" id="blogCategoryModalLongTitle">' . __('Edit ' . htmlspecialchars($category->name) . ' category') . '</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="' . route('admin.blog.category.update', $category->id) . '" method="post" id="blogCategoryForm">
                <input type="hidden" name="_method" value="PATCH">
                <input type="hidden" name="_token" value="' . @csrf_token() . '">
                <div class="modal-body">
                        <p class="card-title"><label for="name">' . __('Category Name') . '</label></p>
                        <div class="form-group">
                            <input type="text" name="name" id="name" class="form-control" required value="' . htmlspecialchars($category->name) . '">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">' . __('Save') . '</button>
                    </div>
                </form>';
            return response()->json($output);

        }catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);

            $this->blog_category->update($request->except(['_method','_token']),$id);
            return $this->backWithSuccess('Category has been updated successfully');

        }catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $this->blog_category->destroy($id);
            return $this->backWithSuccess('Category has been deleted successfully');
        }catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
