<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\CountryService;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminCountryController extends Controller
{
    protected $item;
    public function __construct()
    {
        Parent::__construct();
        $this->item = new CountryService();
    }

    public function index()
    {
        try {
            if (request()->ajax()) {
                $get = $this->item->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='javascript:void(0)' title='Delete' class='sliderDestroyBtn'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.country.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->rawColumns(['action'])->make(true);
            }
            return view('backend.pages.country.index', [
                'title' => 'Country'
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function create()
    {
        try {
            return view('backend.pages.country.form', [
                'title' => 'Country Form'
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ], [
            'name' => 'Country name is required.'
        ]);
        try {
            $country = [];
            $country['name']  =  $request->name;
            $this->item->store($country);
            return $this->backWithSuccess('Country created successfully.');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function destroy($id)
    {
        try {
            $this->item->destroy($id);
            return $this->backWithSuccess('Country has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
