<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\FacilityService;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminFacilityController extends Controller
{

    protected $facility;
    public function __construct()
    {
        Parent::__construct();
        $this->facility = new FacilityService();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            if (request()->ajax()) {
                $get = $this->facility->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='" . route('admin.facility.edit', ['facility' => $get->id]) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-id='" . $get->id . "'>" . __('Edit') . "</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.facility.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->addColumn('icon', function ($get) {
                        return imageShow($get->icon, 'Image', '', 'width="80"');
                    })
                    ->addColumn('status', function ($get) {
                        $status  = "<label class='switch'>
                            <input type='checkbox' " . ($get->status ? 'checked' : '') . " id='" . $get->id . "' class='serviceActivationBtn'>
                            <span class='slider round'></span>
                        </label>";
                        return $status;
                    })
                    ->rawColumns(['action', 'icon', 'status'])->make(true);
            }
            return view('backend.pages.hotel.facility.index', [
                'title' => 'Facility',
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            return view('backend.pages.hotel.facility.form', [
                'title' => 'Facility',
                'item' => null
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $data = [
                'name' => $request->name,
                'status' => (($request->status) ? ACTIVE_STATUS : DEACTIVE_STATUS),
            ];

            if ($request->hasFile('icon')) {
                $data['icon'] = fileUpload($request->icon, UPLOAD_FOLDER_FACIlITY)[0];
            }

            $facility = $this->facility->store($data);
            return $this->backWithSuccess($facility->name . ' has been created successfully');
        } catch (\Exception $th) {
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function facilityShow($id)
    {
        $item = $this->facility->findById($id);
        try {
            if ($item->status) {
                $item->status = false;
                $item->save();
                $msg = 'Facility deactivation successfully.';
                $status = true;
            } else {
                $item->status = true;
                $item->save();
                $msg = 'Facility activation successfully.';
                $status = false;
            }
            return response()->json(['msg' => $msg, 'status' => $status]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            return view('backend.pages.hotel.facility.form', [
                'title' => 'Facility',
                'item' => $this->facility->findById($id)
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $data = [
                'name' => $request->name,
                'status' => (($request->status) ? ACTIVE_STATUS : DEACTIVE_STATUS),
            ];

            $item = $this->facility->findById($id);

            if ($request->hasFile('icon')) {
                $data['icon'] = fileUpload($request->icon, UPLOAD_FOLDER_FACIlITY, $item->getAttributes()['icon'])[0];
            }
            $item->update($data);
            return $this->backWithSuccess($data['name'] . ' Facility has been updated successfully','admin.facility.index');
        } catch (\Exception $th) {
            return $this->backWithError($th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->facility->destroy($id);
            return $this->backWithSuccess('Facility has been deleted successfully');
        } catch (\Exception $th) {
            return back()->with('error', $th->getMessage());
        }
    }
}
