<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminGalleryController extends Controller
{
    public function __construct()
    {
        Parent::__construct();
    }

    public function index()
    {
        try {
            if (request()->ajax()) {
                $get = Gallery::all();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='" . route('admin.gallery.edit', $get->id) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1' data-id='" . $get->id . "'>" . __('Edit') . "</button>
                                </a>
                                <a href='javascript:void(0)' title='Delete' class='sliderDestroyBtn'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.gallery.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->addColumn('image', function ($get) {
                        return imageShow($get->image, 'Image', '', 'width="80"');
                    })
                    ->rawColumns(['action', 'image'])->make(true);
            }
            return view('backend.pages.gallery.index', [
                'title' => 'Gallery',
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function create()
    {
        try {
            return view('backend.pages.gallery.form', [
                'title' => 'Add New Image',
                'gallery' => null
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'image.*' => ['nullable', 'mimes:jpeg,png,jpg,gif']
        ], [
            'title' => 'Gallery title is required.',
        ]);

        try {
            $service = new Gallery();

            if ($request->hasFile('image')) {
                $service->image = fileUpload($request->image, UPLOAD_FOLDER_GALLERY)[0];
            }

            $service->title       =  $request->title;
            $service->save();

            return $this->backWithSuccess('Gallery created successfully.', 'admin.gallery.index');
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function edit($id)
    {
        try {
            $gallery = Gallery::findOrfail($id);
            return view('backend.pages.gallery.form', [
                'title' => 'Edit Gallery',
                'gallery' => $gallery
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function update(Request $request, $id)
    {

        try {
            $request->validate([
                'title' => 'required|string|max:255',
                'image.*' => ['nullable', 'mimes:jpeg,png,jpg,gif']
            ], [
                'title' => 'Gallery title is required.',
            ]);
            $gallery = Gallery::findOrfail($id);

            if ($request->hasFile('image')) {
                $gallery->image = fileUpload($request->image, UPLOAD_FOLDER_GALLERY, $gallery->getAttributes()['image'])[0];
            }

            $gallery->title       =  $request->title;
            $gallery->save();

            return $this->backWithSuccess('Gallery updated successfully.','admin.gallery.index');
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function destroy($id)
    {
        try {
            $gallery = Gallery::findOrfail($id);
            destroryFile(UPLOAD_FOLDER_GALLERY, $gallery->getAttributes()['image']);

            $gallery->delete();
            return $this->backWithSuccess('Gallery has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
