<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\HotelBooking;
use App\Services\HotelBookingService;
use App\Services\HotelServices;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminHotelBookingController extends Controller
{
    protected $hotel_booking;
    protected $hotel;
    public function __construct()
    {
        Parent::__construct();
        $this->hotel = new HotelServices();
        $this->hotel_booking = new HotelBookingService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {
            if (request()->ajax()) {
                $get = $this->hotel_booking->getData();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        return "<div class='d-flex'>
                                <a href='" . route('admin.booking.hotel.show', $get->id) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1' data-id='" . $get->id . "'>" . __('View') . "</button>
                                </a>
                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.booking.hotel.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                    })
                    ->addColumn('hotel', function ($get) {
                        return '<p class="mb-1">
                        <b>' . __('Name: ') . '</b>' . $get->hotel->hotel_name . '</p>
                        <p class="mb-1">
                            <b>' . __('Accommodation: ') . '</b>' . $get->hotelAccommodation->accommodation->name . '
                        </p>
                        <p class="mb-1">
                            <b>' . __('Accommodation Price: ') . '</b>' . currencyFormat($get->hotelAccommodation->price) . '
                        </p>';
                    })
                    ->addColumn('customer', function ($get) {
                        return ' <p class="mb-1">
                        <b>' . __('First Name: ') . '</b>' . $get->first_name . '</p>
                        <p class="mb-1">
                            <b>' . __('Last Name: ') . '</b>' . $get->last_name . '
                        </p>
                        <p class="mb-1">
                            <b>' . __('Email: ') . '</b>' . $get->email . '
                        </p>';
                    })
                    ->addColumn('reservation', function ($get) {
                        return ' <p class="mb-1">
                        <b>' . __('Check In: ') . '</b>' . date('d F, Y H:i A', strtotime($get->check_in)) . '</p>
                        <p class="mb-1">
                            <b>' . __('Check Out: ') . '</b>' . date('d F, Y H:i A', strtotime($get->check_out)) . '
                        </p>
                        <p class="mb-1">
                            <b>' . __('Arrival Time: ') . '</b>' . date('d F, Y H:i A', strtotime($get->arrival_date_time)) . '
                        </p>';
                    })
                    ->addColumn('status', function ($get) {
                        return bookignStatus($get->status);
                    })
                    ->filter(function ($instance) use ($request) {
                        if ($request->get('hotel_id')) {
                            $instance->where('hotel_id', $request->get('hotel_id'));
                        }
                        if (!empty($request->get('search'))) {
                            $instance->whereHas('hotel', function ($w) use ($request) {
                                $search = $request->get('search');
                                $w->where('hotel_name', 'LIKE', "%$search%");
                            });
                        }
                    })
                    ->rawColumns(['action', 'hotel', 'customer', 'reservation', 'status'])->make(true);
            }

            return view('backend.pages.booking.hotel', [
                'title' => 'Hotel Booking',
                'hotels' => $this->hotel->getData()->orderBy('hotel_name')->get()
            ]);
        } catch (\Throwable $e) {
            return $this->backWithError($e->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title = 'Hotel Booking View';
        $hotel_booking = $this->hotel_booking->findById($id);
        return view('backend.pages.booking.hotel-view', compact('title', 'hotel_booking'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->hotel_booking->destroy($id);
            return $this->backWithSuccess(__('Hotel booking delete successfull.'));
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }
}
