<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\HotelServices;
use App\Services\HotelImageServices;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminHotelImageController extends Controller
{
    protected $hotel;
    protected $hotel_image;
    protected $image_path = UPLOAD_FOLDER_HOTEL_IMAGE;
    public function __construct()
    {
        Parent::__construct();
        $this->hotel = new HotelServices();
        $this->hotel_image = new HotelImageServices();
    }
    public function index(Request $request)
    {
        try {
            if (request()->ajax()) {
                $get = $this->hotel_image->getData();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        return "<div class='d-flex'>
                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.hotel.image.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                    })
                    ->addColumn('hotel_name', function ($get) {
                        return (($get->hotel) ? $get->hotel->hotel_name : '');
                    })
                    ->addColumn('hotel_image', function ($get) {
                        return imageShow($get->hotel_image, 'Hotel Image', '', "width='100' height='70'");
                    })
                    ->filter(function ($instance) use ($request) {
                        if ($request->get('hotel_id')) {
                            $instance->where('hotel_id', $request->get('hotel_id'));
                        }
                        if (!empty($request->get('search'))) {
                             $instance->whereHas('hotel',function($w) use($request){
                                $search = $request->get('search');
                                $w->where('hotel_name', 'LIKE', "%$search%");
                            });
                        }
                    })
                    ->rawColumns(['action', 'hotel_image', 'hotel_name'])->make(true);
            }

            return view('backend.pages.hotel-image.index', [
                'title' => 'Hotel Images',
                'hotel_id' => $request->hotel_id,
                'hotels' => $this->hotel->getData()->orderBy('hotel_name')->get()
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    
    public function create()
    {
        try {
            return view('backend.pages.hotel-image.form', [
                'title' => 'Hotel Image Add',
                'hotels' => null,
                'hotelNames' => $this->hotel->getData()->get()
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'hotel_id' => 'required',
            'hotel_image.*' => ['required', 'mimes:jpeg,png,jpg,gif']
        ]);
        try {
            $data_images = [];
            $images = fileUpload($request->hotel_image, $this->image_path);
            foreach ($images as $image) {
                $data_images[] =
                    [
                        'hotel_id' => $request->hotel_id,
                        'hotel_image' => $image,
                    ];
            }

            $this->hotel_image->insert($data_images);

            return $this->backWithSuccess('Hotel images created successfully.','admin.hotel.image.index');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function edit($id)
    {
        try {
            return view('backend.pages.hotel-image.form', [
                'title' => 'Hotel Image Edit',
                'hotels' => $this->hotel_image->findById($id),
                'hotelNames' => $this->hotel->getData()->get()
            ]);
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'hotel_id' => 'required',
                'hotel_image' => ['required', 'mimes:jpeg,png,jpg,gif']
            ]);

            $service = $this->hotel_image->findById($id);

            if ($request->hasFile('hotel_image')) {
                $images = $request->hotel_image;
                $filename = fileUpload($images, $this->image_path, $service->getAttributes()['hotel_image']);
                $service->hotel_image = $filename[0];
            }
            $service->hotel_id  =  $request->hotel_id;
            $service->save();

            return $this->backWithSuccess('Image Updated successfully.','admin.hotel.image.index');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function destroy($id)
    {
        try {
            $this->hotel_image->destroy($id);

            return $this->backWithSuccess('Hotel Image has been deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
