<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AdminOauthSetting extends Controller
{

    public function __construct()
    {
        $this->middleware(['admin']);
        parent::__construct();
    }

    //
    public function getGoogleLoginSettings(Request $request)
    {
        $request->validate([
            'client_id' => $request->is_login ? 'required' : 'nullable',
            'client_secret' => $request->is_login ? 'required' : 'nullable',
        ]);

        try {
            if ($request->isMethod('post')) {
                $status = (($request->is_login) ? 'yes' : 'no');
                envUpdate('ENABLE_GOOGLE_LOGIN', $status);
                envUpdate('GOOGLE_OAUTH_CLIENT_ID', $request->client_id);
                envUpdate('GOOGLE_OAUTH_CLIENT_SECRET', $request->client_secret);

                return $this->backWithSuccess(__('Google Oauth login setting save successfully'));
            }
            $title = __('Oauth Login Setting');
            $google_title = __('Google Oauth Login Setting');
            $facebook_title = __('Facebook Oauth Login Setting');
            return view('backend.pages.settings.oauth.google',compact('title','google_title','facebook_title'));
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }

    public function getFacebookSettings(Request $request)
    {
        $request->validate([
            'client_id' => $request->is_login ? 'required' : 'nullable',
            'client_secret' => $request->is_login ? 'required' : 'nullable',
        ]);

        try {
            if ($request->isMethod('post')) {
                $status = (($request->is_login) ? 'yes' : 'no');
                envUpdate('ENABLE_FACEBOOK_LOGIN', $status);
                envUpdate('FACEBOOK_OAUTH_CLIENT_ID', $request->client_id);
                envUpdate('FACEBOOK_OAUTH_CLIENT_SECRET', $request->client_secret);

                return $this->backWithSuccess(__('Facebook Oauth login setting save successfully'));
            }
            $title = __('Oauth Login Setting');
            $google_title = __('Google Oauth Login Setting');
            $facebook_title = __('Facebook Oauth Login Setting');
            return view('backend.pages.settings.oauth.facebook',compact('title','google_title','facebook_title'));
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }
}
