<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\PackageImageService;
use App\Services\PackageService;

class AdminPackageImagesController extends Controller
{

    protected $package;
    protected $packageImage;
    public function __construct()
    {
        Parent::__construct();
        $this->package = new PackageService();
        $this->packageImage = new PackageImageService;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            return view('backend.pages.packages.package-image.form', [
                'title' => 'Pakage',
                'packages' => $this->package->getData()->get(),
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->packageImage->findById($id);
            $this->packageImage->destroy($id);
            return response()->json(['success' => 'Deleted Successful']);
        } catch (\Throwable $th) {
            return response()->json($th->getMessage());
        }
    }
}
