<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\PaymentMethodService;
use Illuminate\Http\Request;

class AdminPaymentController extends Controller
{
    protected $payment_method;
    public function __construct()
    {
        Parent::__construct();

        $this->payment_method = new PaymentMethodService();
    }

    public function payment()
    {
        try {
            $title = 'Payment';
            $payments = $this->payment_method->getData()->get();
            return view('backend.pages.payment.index', compact('title', 'payments'));
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function paymentFrom()
    {
        try {
            $title = 'Payment';
            $payment = null;
            return view('backend.pages.payment.from', compact('title', 'payment'));
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function paymentEdit($id)
    {
        try {
            $title = 'Payment Edit';
            $payment = $this->payment_method->findById($id);
            return view('backend.pages.payment.from', compact('title', 'payment'));
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function paymentUpdate(Request $request, $id)
    {
        $rules = [
            'name' => 'required',
            'secret_key' => 'required',
        ];
        try {
            $paymentSettingStore = $this->payment_method->findById($id);
            if ($paymentSettingStore->logo == '') {
                $rules['logo'] = ['required', 'mimes:jpeg,jpg,png,gif'];
            }
            if ($paymentSettingStore->method_type == PAYPAL_PAYMENT) {
                $rules['account'] = 'required';
                $rules['client_id'] = 'required';
            }
            if ($paymentSettingStore->method_type == STRIPE_PAYMENT) {
                $rules['api_id'] = 'required';
            }
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
        $request->validate($rules);
        try {

            if ($request->hasFile('logo')) {
                $paymentSettingStore->logo = fileUpload($request->logo, UPLOAD_FOLDER_PAYMENT_METHOD_LOGO, $paymentSettingStore->getAttributes()['logo'])[0];
            }

            $paymentSettingStore->name       = $request->name;
            $paymentSettingStore->account    = $request->account;
            $paymentSettingStore->api_id     = $request->api_id;
            $paymentSettingStore->client_id  = $request->client_id;
            $paymentSettingStore->secret_key = $request->secret_key;
            $paymentSettingStore->save();
            return $this->backWithSuccess('Payment updated successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function paymentDestroy($id)
    {
        try {
            $this->payment_method->destroy($id);
            return $this->backWithSuccess('Payment Deleted successfully.');
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function paymentStatusUpdate(Request $request)
    {
        try {
            $status = ($request->status == DEACTIVE_STATUS) ? ACTIVE_STATUS : DEACTIVE_STATUS;
            $payment_method = $this->payment_method->findById($request->id);
            $active_payment_methods = $this->payment_method->getData()->where(['status' => ACTIVE_STATUS])->count();
            $data = ['status' => $status];
            if ($active_payment_methods == 1) {
                $data['is_default'] = ACTIVE_STATUS;
            }
            $payment_method->update($data);

            $is_default = $payment_method->is_default;
            if ($active_payment_methods == 1 && $payment_method->is_default == DEACTIVE_STATUS) {
                $is_default = ACTIVE_STATUS;
            }
            if ($active_payment_methods == 0 && $payment_method->is_default == ACTIVE_STATUS) {
                $is_default = DEACTIVE_STATUS;
            }

            return response()->json(['id' => $request->id, 'is_default' => $is_default, 'status' => true, 'update_status' => $status, 'msg' => __('Status change successfully')]);
        } catch (\Throwable $th) {
            return response()->json(['status' => false, 'msg' => __('Something wrong. Please try again')]);
        }
    }

    public function paymentDefaultUpdate(Request $request)
    {
        try {
            $active_payment_methods = $this->payment_method->getData()->where(['status' => ACTIVE_STATUS])->count();
            $status = ($active_payment_methods == 0) ? DEACTIVE_STATUS : ACTIVE_STATUS;
            $this->payment_method->getData()->update(['is_default' => DEACTIVE_STATUS]);
            $this->payment_method->update(['is_default' => $status], $request->id);
            $payment_method = $this->payment_method->getData()->where(['is_default' => ACTIVE_STATUS])->first();

            return response()->json(['status' => true, 'msg' => __('Default change successfully'), 'id' => $payment_method->id, 'status' => $payment_method->status]);
        } catch (\Throwable $th) {
            return response()->json(['status' => false, 'msg' => __('Something wrong. Please try again')]);
        }
    }
}
