<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Services\TagServices;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AdminTagController extends Controller
{
    protected $tag;
    public function __construct()
    {
        Parent::__construct();
        $this->tag = new TagServices();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            if (request()->ajax()) {
                $get = $this->tag->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='javascript:void(0)'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-route=' " . route('admin.blog.tag.show', $get->id) . "'>" . __('Edit') . "</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.blog.tag.destroy', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->rawColumns(['action'])->make(true);
            }

            return view('backend.pages.blogs.tag', [
                'title' => 'Tag',
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $tag = $this->tag->store([
                'name' => $request->input('name')
            ]);
            return $this->backWithSuccess($tag->name . ' has been created successfully');
        } catch (\Exception $th) {
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $tag = $this->tag->findById($id);
        try {
            $output = '<div class="modal-header">
                    <h5 class="modal-title card-title" id="blogTagModalLongTitle">' . __('Edit ' . htmlspecialchars($tag->name) . ' tag') . '</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="' . route('admin.blog.tag.update', $tag->id) . '" method="post" id="blogTagForm">
                <input type="hidden" name="_method" value="PATCH">
                <input type="hidden" name="_token" value="' . @csrf_token() . '">
                <div class="modal-body">
                        <p class="card-title"><label for="name">' . __('Tag Name') . '</label></p>
                        <div class="form-group">
                            <input type="text" name="name" id="name" class="form-control" required value="' . htmlspecialchars($tag->name) . '">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">' . __('Save') . '</button>
                    </div>
                </form>';
            return response()->json($output);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string|max:255'
            ]);
            $tag['name'] = $request->name;
            $this->tag->update($tag, $id);
            return $this->backWithSuccess($tag['name'] . ' tag has been updated successfully');
        } catch (\Exception $th) {
            return $this->backWithError($th->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->tag->destroy($id);
            return $this->backWithSuccess('Tag has been deleted successfully');
        } catch (\Exception $th) {
            return back()->with('error', $th->getMessage());
        }
    }
}
