<?php

namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\TestimonialRequest;
use App\Services\TestimonialServices;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class TestimonialController extends Controller
{
    protected $testimonial;
    public function __construct()
    {
        Parent::__construct();
        $this->testimonial = new TestimonialServices();
    }
    public function index()
    {
        try {
            $title = __('Testimonial');
            if (request()->ajax()) {
                $get = $this->testimonial->getData()->get();
                return DataTables::of($get)
                    ->addIndexColumn()
                    ->addColumn('action', function ($get) {
                        $button  = "<div class='d-flex'>
                                <a href='" . route('admin.testimonial.edit', $get->id) . "'>
                                    <button type='button' class='btn btn-sm btn btn-success m-1 blogCategoryEditBtn' data-id='" . $get->id . "'>" . __('Edit') . "</button>
                                </a>

                                <a href='javascript:void(0)' title='Delete' class='deleteRow'>
                                    <button type='button' class='btn btn-sm btn btn-danger m-1'>" . __('Delete') . "</button>
                                    <form action=" . route('admin.testimonial.delete', $get->id) . " method='post' class='deleteForm'>
                                        " . csrf_field() . "
                                        <input type='hidden' name='_method' value='delete'>
                                    </form>
                                </a>
                            </div>";
                        return $button;
                    })
                    ->addColumn('image', function ($get) {
                        return imageShow($get->image, 'Image', '', 'width="80"');
                    })
                    ->addColumn('status', function ($get) {
                        $status  = "<label class='switch'>
                <input type='checkbox' " . ($get->status ? 'checked' : '') . " id='" . $get->id . "' class='serviceActivationBtn'>
                <span class='slider round'></span>
            </label>";
                        return $status;
                    })
                    ->rawColumns(['action', 'image', 'status'])->make(true);
            }
            return view('backend.pages.testimonial.index', compact('title'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function form()
    {
        try {
            $title = __('Testimonial Form');
            return view('backend.pages.testimonial.form', compact('title'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function store(TestimonialRequest $request)
    {
        try {
            $acceptable = ['jpeg', 'png', 'jpg', 'gif'];
            if ($request->hasFile('image')) {
                foreach ($request->image as $img) {
                    if (!in_array($img->getClientOriginalExtension(), $acceptable)) {
                        $notification = array(
                            'message' => 'Only jpeg, png, jpg and gif file is supported.',
                            'alert-type' => 'error'
                        );
                        return back()->with($notification);
                    }
                }
            }
            $data = [];
            if ($request->hasFile('image')) {
                $data['image'] = fileUpload($request->image, UPLOAD_FOLDER_TESTIMONIAL)[0];
            }

            $data['name'] = $request->name;
            $data['designation'] = $request->designation;
            $data['testimonial'] = $request->testimonial;
            $data['rating'] = $request->rating;
            $data['video_link'] = $request->video_link;
            $data['status'] = $request->status == 'on' ? true : false;

            $this->testimonial->store($data);
            $notification = array(
                'message' => 'Testimonial has been added successfully',
                'alert-type' => 'success'
            );
            return redirect()->back()->with($notification);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\RedirectResponse
     */
    public function show($id)
    {
        $item = $this->testimonial->findById($id);
        try {
            if ($item->status) {
                $item->status = false;
                $item->save();
                $msg = 'Testimonial deactivation successfully.';
                $status = true;
            } else {
                $item->status = true;
                $item->save();
                $msg = 'Testimonial activation successfully.';
                $status = false;
            }
            return response()->json(['msg' => $msg, 'status' => $status]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function edit($id)
    {
        try {
            $title = __('Edit Testimonial');
            $values = $this->testimonial->findById($id);
            return view('backend.pages.testimonial.edit', compact('title', 'values'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function update(TestimonialRequest $request, $id)
    {
        try {
            $acceptable = ['jpeg', 'png', 'jpg', 'gif'];
            if ($request->hasFile('image')) {
                foreach ($request->image as $img) {
                    if (!in_array($img->getClientOriginalExtension(), $acceptable)) {
                        $notification = array(
                            'message' => 'Only jpeg, png, jpg and gif file is supported.',
                            'alert-type' => 'error'
                        );
                        return back()->with($notification);
                    }
                }
            }
            $data = $this->testimonial->findById($id);
            if ($request->hasFile('image')) {
                $data->image = fileUpload($request->image, UPLOAD_FOLDER_TESTIMONIAL, $data->getAttributes()['image'])[0];
            }

            $data->name = $request->name;
            $data->designation = $request->designation;
            $data->testimonial = $request->testimonial;
            $data->rating = $request->rating;
            $data->video_link = $request->video_link;
            $data->status = $request->status == 'on' ? true : false;
            $data->save();
            $notification = array(
                'message' => 'Testimonial has been updated successfully',
                'alert-type' => 'success'
            );
            return redirect()->back()->with($notification);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function delete($id)
    {
        try {
            $this->testimonial->destroy($id);
            $notification = [
                'message' =>  'Testimonial has been deleted successfully..',
                'alert-type' => 'success'
            ];
            return back()->with($notification);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
