<?php

namespace App\Http\Controllers\GuestViewControllers;

use App\Http\Controllers\Controller;
use App\Services\PackageService;
use App\Models\PageSettings;

class GuestPackageController extends Controller
{

    protected $package;
    public function __construct()
    {
        parent::__construct();
        $this->package = new PackageService();
    }
    public function packageDetails($id)
    {
        try {
            $package = $this->package->findById($id);
            $discount = $package->discount->discount;
            $sub_price = $package->subPrice;
            $page = PageSettings::where('name', 'places')->first();
            $pageContent = $page->sections()->where('name', 'places_page')->first();

            return view('frontend.pages.packages.singlePackage', [
                'title' => 'Pakage',
                'package' => $package,
                'discount' => $discount,
                'sub_price' => $sub_price,
                'pageContent' => $pageContent,
            ]);
        } catch (\Exception $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
}
