<?php

namespace App\Http\Controllers\MenuSettings;

use App\Http\Controllers\Controller;
use App\Models\Href;
use App\Models\Menu;
use App\Models\MenuCategory;
use Illuminate\Http\Request;

class MenuItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        try {

            $title = 'Header Menu';
            $hrefs = Href::all();
            $menus = Menu::with(['childs'])->orderby('position', 'asc')->where(['category_id' => $request->menu])->get();
            $menuHtml = buildMenu($menus);
            $category_id = $request->menu;

            return view('backend.pages.settings.menu-settings.menu-item.index', compact('menuHtml', 'title', 'hrefs', 'category_id'));
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function storeMenu(Request $request)
    {
        $this->validate($request, [
            'text' => ['required', 'string', 'max:255'],
            'href' => ['required'],
            'target' => ['required']
        ]);

        if ($request->id) {
            Menu::where(['id' => $request->id])->update($request->except('_token'));
        } else {
            $request->request->add(['position' => 1, 'icon' => 'empty']);
            Menu::create($request->except('_token'));
        }

        $message = [
            'message' =>  __('Menu Save successful!'),
            'alert-type' => 'success'
        ];

        return redirect()->route('admin.menu.item.index', ['menu' => $request->category_id])->with($message);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function orderStore(Request $request)
    {
        $list = $request->list;

        if($list) {
            for ($i = 0; $i < count($list); $i++) {
                if ($itemToOrder = Menu::find($list[$i]['id'])) {
                    $itemToOrder->position = $i + 1;
                    $itemToOrder->parent_id = null;
                    $itemToOrder->save();

                    if (isset($list[$i]['children']) && count($list[$i]['children'])) {
                        for ($c_i = 0; $c_i < count($list[$i]['children']); $c_i++) {
                            if ($itemToOrder = Menu::find($list[$i]['children'][$c_i]['id'])) {
                                $itemToOrder->position = $c_i + 1;
                                $itemToOrder->parent_id = $list[$i]['id'];
                                $itemToOrder->save();
                            }
                        }
                    }
                }
            }
            return response()->json(['msg' => __('Menu order save successfully')]);
        }
    }

    /**
     * store status the specified resource from storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function menuStatus(Request $request)
    {
        $status = ($request->status == ACTIVE_STATUS) ? DEACTIVE_STATUS : ACTIVE_STATUS;
        Menu::where(['id' => $request->id])->update(['status' => $status]);

        return response()->json(['msg' => __('Menu status save successfully'), 'status' => $status]);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteMenu(Request $request)
    {
        try {
            Menu::findorfail($request->id)->delete();

            $message = [
                'message' =>  __('Menu delete successful!'),
                'alert-type' => 'success'
            ];
            return redirect()->back()->with($message);
        } catch (\Throwable $th) {
            session()->flash('success', __('Something went wrong. Please try again'));
            return redirect()->back();
        }
    }
}
