<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class OAuthController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }
    public function oauthRedirect($type)
    {
        return Socialite::driver($type)->redirect();
    }

    public function oauthCallBack($type)
    {
        try {
            $provider = Socialite::driver($type)->user();

            $user = User::where('email', $provider->email)->first();
            $user = $this->userSaveUpdate($user, $provider);
            Auth::login($user);

            return redirect()->route('guest.dashboard');
        } catch (\Throwable $th) {
            return $this->backWithError($th->getMessage());
        }
    }

    private function userSaveUpdate($user, $provider)
    {
        if (!$user) {
            $user = User::create([
                'user_type' => GUEST_USER,
                'name' => $provider->name,
                'email' => $provider->email,
            ]);
        }

        return $user;
    }
}
