<?php

namespace App\Http\Controllers;

use App\Models\HotelBooking;
use App\Models\PackageBooking;
use App\Models\User;
use App\Services\BookingService;
use App\Services\Payment\StripeService;
use App\Services\PaymentTransactionService;
use Illuminate\Http\Request;

class StripeController extends Controller
{
    protected $booking;
    public function __construct()
    {
        $this->booking = new BookingService();
    }

    public function capturePayment(Request $request)
    {
        $stripe = new StripeService(paymentMethod(STRIPE_PAYMENT)->secret_key);

        if ($request->bookingType == BOOKING_HOTEL) {
            $booking = HotelBooking::find($request->bookingId);
            $amount = discountPriceCalculate($booking->hotelAccommodation->price, $booking->hotel->discount, false);
        } else if ($request->bookingType == BOOKING_PACKAGE) {
            $booking = PackageBooking::find($request->bookingId);
            $amount = discountPriceCalculate($booking->packageSubPrice->tour_price, $booking->package->discount, false);
        }

        $user = User::find($request->userId);
        if (!$user->stripe_id) {
            $customer = $stripe->createCustomer($user, $request->paymentMethod);
            $user->stripe_id = $customer->id;
            $user->save();
        }

        $stripe->attachPaymentMethod($request->paymentMethod, $user->stripe_id);


        $charge = $stripe->charge($amount['price'] ?? 0, $request->paymentMethod, $user->stripe_id);

        return $charge;
    }

    public function paymentSuccess(Request $request)
    {
        try {
            $transaction = new PaymentTransactionService();
            $transaction->save($request, STRIPE_PAYMENT);

            if ($request->type == BOOKING_HOTEL) {
                $booking = HotelBooking::find($request->bookingId);
                $booking->update(['status' => BOOKING_STATUS_CONFIRM]);
                $this->booking->confirm(['type' => BOOKING_HOTEL, 'booking' => $booking]);
                return array('status' => 'success', 'message' => 'Hotel Booking confirmed. Hotel authority will review your booking and give you confirmation. Thanks');
            } else if ($request->type == BOOKING_PACKAGE) {
                $booking = PackageBooking::find($request->bookingId);
                $booking->update(['status' => BOOKING_STATUS_CONFIRM]);
                $this->booking->confirm(['type' => BOOKING_PACKAGE, 'booking' => $booking]);
                return array('status' => 'success', 'message' => 'Package Booking confirmed. Package authority will review your booking and give you confirm. Thanks');
            }
        } catch (\Exception $e) {
            return array('status' => 'failed', 'message' => $e->getMessage());
        }
    }
}
