<?php

namespace App\Http\Livewire\Admin\LeftNav;

use App\Services\HotelBookingService;
use App\Services\PackageBookingService;
use Livewire\Component;

class BookingCount extends Component
{
    public $booking_count;
    public function mount()
    {
        $hotel_booking = new HotelBookingService();
        $package_booking = new PackageBookingService;
        $hotel_booking_count = $hotel_booking->getData()
            ->orWhere(function ($query) {
                $query->where('status', BOOKING_STATUS_PENDING)
                    ->orWhere('status', BOOKING_STATUS_CONFIRM);
            })
            ->count();

        $package_booking_count = $package_booking->getData()
            ->orWhere(function ($query) {
                $query->where('status', BOOKING_STATUS_PENDING)
                    ->orWhere('status', BOOKING_STATUS_CONFIRM);
            })
            ->count();

        $this->booking_count = $hotel_booking_count + $package_booking_count;
    }
    public function render()
    {
        return view('livewire.admin.left-nav.booking-count');
    }
}
