<?php

namespace App\Http\Livewire\Admin\LeftNav;

use App\Services\HotelBookingService;
use Livewire\Component;

class HotelBookingCount extends Component
{
    public $hotel_booking_count;

    public function mount()
    {
        $hotel_booking = new HotelBookingService();

        $this->hotel_booking_count = $hotel_booking->getData()
            ->orWhere(function ($query) {
                $query->where('status', BOOKING_STATUS_PENDING)
                    ->orWhere('status', BOOKING_STATUS_CONFIRM);
            })
            ->count();
    }

    public function render()
    {
        return view('livewire.admin.left-nav.hotel-booking-count');
    }
}
