<?php

namespace App\Http\Requests;

use App\Models\SocialMediaSettings;
use Illuminate\Foundation\Http\FormRequest;

class SocialMediaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $socialMediaForms = SocialMediaSettings::pluck('name')->toArray();

        $rules = [];

        foreach ($socialMediaForms as $platform) {
            $rules[$platform] = 'url|nullable';
        }

        return $rules;
    }
}
