<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CustomMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $message_html;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject,$message_html)
    {
        $this->message_html = $message_html;
        $this->subject = $subject;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.custom-mail')->subject($this->subject);
    }
}
