<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attorney extends Model
{
    use HasFactory;
    protected $fillable = ['user_id', 'designation_id','name','image','phone','email','address','description','status'];

    public function getImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_ATTORNEYS . $value)) && $value) ? asset(UPLOAD_FOLDER_ATTORNEYS . $value) : '');
    }

    public function designation(){
        return $this->belongsTo(Designation::class, 'designation_id', 'id');
    }
}
