<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Blog extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'title', 'slug', 'description', 'bg_image', 'feature_img', 'category_id', 'is_featured', 'is_popular'];

    public function setSlugAttribute($value)
    {
        $this->attributes['slug'] = Str::of($value)->slug('-');
    }

    public function getBgImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_BLOGS_BG_IMAGES . $value)) && $value) ? asset(UPLOAD_FOLDER_BLOGS_BG_IMAGES . $value) : '');
    }

    public function getFeatureImgAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_BLOGS_FEATURES . $value)) && $value) ? asset(UPLOAD_FOLDER_BLOGS_FEATURES . $value) : '');
    }

    public function category()
    {
        return $this->belongsTo(BlogCategory::class, 'category_id', 'id');
    }

    public function blogTags()
    {
        return $this->hasMany(BlogTag::class, 'blog_id', 'id');
    }
    public function userId()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function comment()
    {
        return $this->hasMany(Comment::class, 'blog_id', 'id');
    }
}
