<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use HasFactory;
    protected $fillable = ['country_id', 'name'];
    public function country()
    {
        return $this->belongsTo(City::class, 'country_id', 'id');
    }
    public function hotel()
    {
        return $this->hasOne(Hotel::class, 'city', 'id');
    }
}
