<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
    use HasFactory;
    protected $fillable = ['title', 'image'];

    public function getImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_GALLERY . $value)) && $value) ? asset(UPLOAD_FOLDER_GALLERY . $value) : '');
    }
}
