<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hotel extends Model
{
    use HasFactory;
    protected $fillable = [
        'hotel_primary_image', 'feature_image','hotel_name', 'hotel_location',
        'description', 'latitude', 'longitude', 'breakfast_info',
        'country', 'city', 'parking_info', 'hotel_to_stay_title',
        'hotel_to_stay_description', 'price',
        'facilities', 'phone', 'email', 'website', 'status'
    ];

    public function getHotelPrimaryImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_HOTELS . $value)) && $value) ? asset(UPLOAD_FOLDER_HOTELS . $value) : '');
    }

    public function hotelImages()
    {
        return $this->hasMany(HotelImage::class, 'hotel_id', 'id');
    }

    public function hotelCountry()
    {
        return $this->belongsTo(Country::class, 'country', 'id');
    }

    public function hotelCity()
    {
        return $this->belongsTo(City::class, 'city', 'id');
    }

    public function hotelAccomodation()
    {
        return $this->hasMany(HotelAccommodation::class, 'hotel_id', 'id');
    }

    public function discount()
    {
        return $this->hasOne(DiscountSub::class, 'hotel_id', 'id')
            ->with(['discount'])
            ->orWhere(function ($query) {
                $query->whereDate('start_date_time', '>=', now())
                    ->orWhereDate('end_date_time', '<=', now());
            });
    }
}
