<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HotelAccommodation extends Model
{
    use HasFactory;

    protected $fillable = ['hotel_id', 'accommodation_id', 'no_of_room', 'price', 'no_of_adult', 'no_of_children', 'room_size', 'facilities', 'is_smoking', 'room_images'];

    public function accommodation()
    {
        return $this->belongsTo(Accommodation::class, 'accommodation_id', 'id');
    }

    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id', 'id');
    }
}
