<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HotelBooking extends Model
{
    use HasFactory;

    protected $fillable = [
        'hotel_id', 'hotel_accommodation_id', 'discount_id',
        'user_id', 'check_in', 'check_out',
        'total_night', 'first_name', 'last_name',
        'email', 'is_travel_for_work', 'status', 'arrival_date_time',
        'amount', 'rating', 'discount_amount','net_amount'
    ];

    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id', 'id');
    }

    public function hotelAccommodation()
    {
        return $this->belongsTo(HotelAccommodation::class, 'hotel_accommodation_id', 'id')->with(['hotel', 'accommodation']);
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class, 'discount_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getCountry()
    {
        return $this->belongsTo(Country::class, 'country', 'id');
    }

    public function getCity()
    {
        return $this->belongsTo(Country::class, 'city', 'id');
    }
}
