<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HotelImage extends Model
{
    use HasFactory;
    protected $fillable = ['hotel_id', 'hotel_image'];

    public function getHotelImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_HOTEL_IMAGE . $value)) && $value) ? asset(UPLOAD_FOLDER_HOTEL_IMAGE . $value) : '');
    }

    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id', 'id');
    }
}
