<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LogoSettings extends Model
{
    use HasFactory;

    protected $fillable = ["logo", "favicon", "site_tag_image"];

    public function getLogoAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_SETTINGS . $value)) && $value) ? asset(UPLOAD_FOLDER_SETTINGS . $value) : '');
    }

    public function getFaviconAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_SETTINGS . $value)) && $value) ? asset(UPLOAD_FOLDER_SETTINGS . $value) : '');
    }
}
