<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;
    protected $fillable = [
        'category_id', 'place_id', 'title', 'sub_title', 'day', 'price',
        'location', 'best_time_to_go', 'tour_attractions', 'tour_availability', 'next_scheduled_tour',
        'description', 'inclusion', 'exclusion', 'tour_highlight','price',
        'tour_itineraries', 'notes', 'tour_map_image', 'status', 'is_spacial'
    ];

    public function getTourMapImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_PACKAGE_IMAGE . $value)) && $value) ? asset(UPLOAD_FOLDER_PACKAGE_IMAGE . $value) : '');
    }

    public function category()
    {
        return $this->belongsTo(PackageCategory::class, 'category_id', 'id');
    }

    public function images()
    {
        return $this->hasMany(PackageImage::class, 'package_id', 'id');
    }

    public function subPrice()
    {
        return $this->hasMany(PackageSubPrice::class, 'package_id', 'id');
    }

    public function departure()
    {
        return $this->hasOne(PackageDepartureAndAvilability::class, 'package_id', 'id');
    }

    public function discount()
    {
        return $this->hasOne(DiscountSub::class, 'package_id', 'id')
            ->with(['discount'])
            ->orWhere(function ($query) {
                $query->whereDate('start_date_time', '>=', now())
                    ->orWhereDate('end_date_time', '<=', now());
            });
    }
}
