<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Services\EventServices;
use App\Services\TestimonialServices;

class PageSectionInputs extends Model
{
    use HasFactory;

    // home page section inputs
    public function slider($page)
    {
        $events = new EventServices();
        $discounts = Discount::all();
        $slider = $page->sections()->where('name', PAGE_GROUP_SLIDER)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_SLIDER . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($slider ? ($slider->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($slider ? ($slider->show ? '' : 'd-none') : 'd-none') . '">

                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_slider'
        ];
    }
    public function place($page)
    {
        $settingsPage = $page;
        $place = $settingsPage->sections()->where('name', PAGE_GROUP_PLACE)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PLACE . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($place ? ($place->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($place ? ($place->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($place ? clean($place->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($place ? clean($place->sub_title) : '') . '">
                                    </div>

                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($place ? clean($place->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                     <label for="total-attorney" class="card-title">' . __('Number of image shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($place ? clean($place->number_of_content) : '') . '">
                                     </div>
                                </div>

                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($place ? ($place->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_service'
        ];
    }
    public function feature($page)
    {
        $settingsPage = $page;
        $feature = $settingsPage->sections()->where('name', PAGE_GROUP_FEATURE)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_FEATURE . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">

                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($feature ? ($feature->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($feature ? ($feature->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($feature ? clean($feature->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($feature ? clean($feature->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="10" >' . ($feature ? clean($feature->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of feature shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($feature ? clean($feature->number_of_content) : '') . '">
                                    </div>
                                    <p class="mb-1 text-left">About section feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="home-page-about-img" id="about_left_img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($feature && $feature->fnt_img) {
            $cardBody .= imageShow($feature->fnt_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $feature->id, 'fnt_img');
        }
        $cardBody .= '</div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_left_img'
        ];
    }
    public function package($page)
    {
        $discounts = Discount::all();
        $settingsPage = $page;
        $package = $settingsPage->sections()->where('name', PAGE_GROUP_PACKAGE)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PACKAGE . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($package ? ($package->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($package ? ($package->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($package ? clean($package->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($package ? clean($package->sub_title) : '') . '">
                                    </div>

                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($package ? clean($package->description) : '') . '</textarea>
                                    </div>
                                     <div class="form-group">
                                     <label for="total-attorney" class="card-title">' . __('Number of Package') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($package ? clean($package->number_of_content) : '') . '">
                                     </div>
                                    <div class="form-group">
                                        <label for="total-attorney" class="card-title">' . __('Discount List:') . '</label>
                                        <select class="form-control form-control-lg" name="slider_package_discount">
                                            <option value="">'. __('Select') .'</option>';
                                        foreach ($discounts as $discount) {
                                            $cardBody .= '<option  value="' . $discount->id . '" '.(($package && $package->slider_package_discount == $discount->id) ? 'selected' : '').'>' . $discount->title . '</option>';
                                        }
                                        $cardBody .= '</select>
                                    </div>

                                </div>

                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($package ? ($package->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_service'
        ];
    }
    public function hotel($page)
    {
        $settingsPage = $page;
        $hotel = $settingsPage->sections()->where('name', PAGE_GROUP_HOTEL)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_HOTEL . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($hotel ? ($hotel->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($hotel ? ($hotel->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($hotel ? clean($hotel->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($hotel ? clean($hotel->sub_title) : '') . '">
                                    </div>

                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($hotel ? clean($hotel->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                     <label for="total-attorney" class="card-title">' . __('Number of Hotel') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($hotel ? clean($hotel->number_of_content) : '') . '">
                                     </div>
                                </div>

                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($hotel ? ($hotel->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_service'
        ];
    }
    public function award($page)
    {
        $settingsPage = $page;
        $award = $settingsPage->sections()->where('name', PAGE_GROUP_AWARD)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                  <input type="hidden" name="page" value="home">
                  <input type="hidden" name="group" value="' . PAGE_GROUP_AWARD . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($award ? ($award->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($award ? ($award->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title:') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($award ? clean($award->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title:') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($award ? clean($award->sub_title) : '') . '">
                                    </div>

                                     <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Youtube URL:') . '</label>
                                        <input type="text" name="youtube_url" id="right-about-subtitle" class="form-control"  value="' . ($award ? clean($award->youtube_url) : '') . '">
                                    </div>
                                    <p class="mb-1 text-left">Feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="home-page-award-fnt-img" id="home-page-award-fnt-img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($award && $award->fnt_img) {
            $cardBody .= imageShow($award->fnt_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $award->id, 'fnt_img');
        }
        $cardBody .= '</div>
                                <div class="col-6">
                                <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description:') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="9" >' . ($award ? clean($award->description) : '') . '</textarea>
                                    </div>

                                <p class="mb-1 text-left">Background image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="home-page-award-bg-img" id="home-page-award-bg-img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($award && $award->bg_img) {
            $cardBody .= imageShow($award->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $award->id, 'bg_img');
        }
        $cardBody .= '</div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($award ? ($award->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_award'
        ];
    }
    public function about($page)
    {
        $settingsPage = $page;
        $about = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($about ? ($about->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($about ? clean($about->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($about ? clean($about->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="10" >' . ($about ? clean($about->description) : '') . '</textarea>
                                    </div>

                                </div>
                                <div class="col-md-6 text-center">
                                    <p class="mb-1 text-left">About section feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="home-page-about-img" id="about_left_img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($about && $about->fnt_img) {
            $cardBody .= imageShow($about->fnt_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $about->id, 'fnt_img');
        }
        $cardBody .= '<div class="">
                                       <p class="mb-1 text-left">' . __('About Image Phone Number') . '</p>
                                           <input type="text" name="about_image_phone" id="contact-title" class="form-control"  value="' . ($about ? clean($about->about_image_phone) : '') . '">
                                       </div>
                                </div>

                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_left_img'
        ];
    }

    public function gallery($page)
    {
        $settingsPage = $page;
        $gallery = $settingsPage->sections()->where('name', PAGE_GROUP_GALLERY)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_GALLERY . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($gallery ? ($gallery->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($gallery ? ($gallery->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($gallery ? clean($gallery->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($gallery ? clean($gallery->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($gallery ? clean($gallery->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of galleries shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($gallery ? clean($gallery->number_of_content) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($gallery ? ($gallery->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_gallery'
        ];
    }

    public function testimonial($page)
    {
        $settingsPage = $page;
        $testimonial = $settingsPage->sections()->where('name', PAGE_GROUP_TESTIMONIAL)->first();
        $testimonial_service = new TestimonialServices;
        $testimonials = $testimonial_service->getData()->get();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_TESTIMONIAL . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($testimonial ? ($testimonial->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($testimonial ? ($testimonial->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($testimonial ? clean($testimonial->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Left side testimonial') . '</label>
                                        <select class="form-control" name="testimonial_id">
                                            <option value="">'.__('Select review').'</option>';
                                        foreach ($testimonials as $testimonial_) {
                                            $cardBody .= '<option value="'.$testimonial_->id.'" '.(($testimonial && $testimonial->testimonial_id == $testimonial_->id) ? 'selected' : '').'>'.$testimonial_->name.' - '.$testimonial_->testimonial.'</option>';
                                        }
                                        $cardBody .= '</select>
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of testimonial shown on right side?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($testimonial ? clean($testimonial->number_of_content) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($testimonial ? ($testimonial->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_testimonial'
        ];
    }
    public function promotional($page)
    {
        $settingsPage = $page;
        $promotional = $settingsPage->sections()->where('name', PAGE_GROUP_PROMOTIONAL)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PROMOTIONAL . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">

                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($promotional ? ($promotional->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($promotional ? ($promotional->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($promotional ? clean($promotional->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="10" >' . ($promotional ? clean($promotional->description) : '') . '</textarea>
                                    </div>
                                     <div class="row">
                                       <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 1:') . '</label>
                                            <input type="text" name="btn_1" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_1) : '') . '">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 2:') . '</label>
                                            <input type="text" name="btn_2" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_2) : '') . '">
                                        </div>
                                    </div>
                                     <div class="row">
                                       <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 1 URL:') . '</label>
                                            <input type="text" name="btn_1_url" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_1_url) : '') . '">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 2 URL:') . '</label>
                                            <input type="text" name="btn_2_url" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_2_url) : '') . '">
                                        </div>
                                    </div>
                                    <p class="mb-1 text-left">About section feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="promotional_home_img" id="promotional_home_img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($promotional && $promotional->bg_img) {
            $cardBody .= imageShow($promotional->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $promotional->id, 'bg_img');
        }

        $promotional .= '</div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'promotional_home_img'
        ];
    }
    public function blog($page)
    {
        $settingsPage = $page;
        $blog = $settingsPage->sections()->where('name', PAGE_GROUP_BLOG)->first();
        $input = '<input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_BLOG . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($blog ? ($blog->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($blog ? ($blog->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($blog ? clean($blog->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($blog ? clean($blog->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($blog ? clean($blog->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of blogs shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($blog ? clean($blog->number_of_content) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($blog ? ($blog->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'home_page_blog'
        ];
    }


    // contact page section inputs
    public function contact_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $page = $settingsPage->sections()->where('name', PAGE_GROUP_CONTACT_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_CONTACT . '">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_CONTACT_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="contact-page-breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($page && $page->bg_img) {
            $cardBody .= imageShow($page->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $page->id, 'bg_img');
        }

        $cardBody .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($page ? clean($page->title) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_CONTACT_BREADCUMB_BG_IMG
        ];
    }
    
    // contact page right heading
    public function contact_right_heading($page)
    {
        $settingsPage = $page;
        $page = $settingsPage->sections()->where('name', PAGE_GROUP_CONTACT_RIGHT_HEADING)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_CONTACT . '">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_CONTACT_RIGHT_HEADING . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-12 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($page ? ($page->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 form-group">
                                    <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                    <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($page ? clean($page->description) : '')  . '</textarea>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_CONTACT_RIGHT_HEADING
        ];
    }

    // contact page left
    public function contact_left($page)
    {
        $settingsPage = $page;
        $page = $settingsPage->sections()->where('name', PAGE_GROUP_CONTACT_LEFT)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_CONTACT . '">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_CONTACT_LEFT . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-12 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($page ? ($page->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 form-group">
                                    <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                    <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($page ? clean($page->description) : '')  . '</textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show Form') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" name="form_title" ' . ($page ? ($page->form_title ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_CONTACT_LEFT
        ];
    }

    // contact info
    public function contact_info($page)
    {
        $settingsPage = $page;
        $contact_page = $settingsPage->sections()->where('name', PAGE_GROUP_CONTACT_INFO)->first();
        $input = '<input type="hidden" name="page" value="contact">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_CONTACT_INFO . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($contact_page ? ($contact_page->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($contact_page ? ($contact_page->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($contact_page ? clean($contact_page->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="contact-line-one" class="card-title">' . __('Line One') . '</label>
                                        <input type="text" name="line_one" id="contact-line-one" class="form-control"  value="' . ($contact_page ? clean($contact_page->line_one) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="contact-line-two" class="card-title">' . __('Line Two') . '</label>
                                        <input type="text" name="line_two" id="contact-line-two" class="form-control" value="' . ($contact_page ? clean($contact_page->line_two) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($contact_page ? ($contact_page->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'contact_page_contact_info'
        ];
    }

    public function business_hour($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_BUSINESS_HOUR)->first();
        $input = '<input type="hidden" name="page" value="contact">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_BUSINESS_HOUR . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="hour-line-one" class="card-title">' . __('Line One') . '</label>
                                        <input type="text" name="line_one" id="hour-line-one" class="form-control"  value="' . ($item ? clean($item->line_one) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="hour-line-two" class="card-title">' . __('Line Two') . '</label>
                                        <input type="text" name="line_two" id="hour-line-two" class="form-control" value="' . ($item ? clean($item->line_two) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'contact_page_business_hour'
        ];
    }

    public function email($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_EMAIL)->first();
        $input = '<input type="hidden" name="page" value="contact">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_EMAIL . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '  name="show">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="email-one" class="card-title">' . __('Email One') . '</label>
                                        <input type="email" name="line_one" id="email-one" class="form-control"  value="' . ($item ? clean($item->line_one) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="email-two" class="card-title">' . __('Email Two') . '</label>
                                        <input type="email" name="line_two" id="email-two" class="form-control" value="' . ($item ? clean($item->line_two) : '') . '">
                                    </div>
                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'contact_page_email'
        ];
    }

    // about page section inputs
    public function about_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="about">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="about-page-breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-50 mt-4 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody  .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_breadcumb_bg_img'
        ];
    }

    public function left_about_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_LEFT_ABOUT_IMG)->first();
        $input = '<input type="hidden" name="page" value="about">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_LEFT_ABOUT_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                                <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($item ? clean($item->sub_title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                                <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($item ? clean($item->description) : '') . '</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';

        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'left_about_img'
        ];
    }

    public function right_about($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_RIGHT_ABOUT)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="about">
                        <input type="hidden" name="group" value="right_about">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6 text-center">';
        if ($item && $item->fnt_img) {
            $cardBody .= imageShow($item->fnt_img, 'Image', 'img-thumbnail w-50 mt-4 border', '', 'App\Models\PageSectionSettings', $item->id, 'fnt_img');
        }
        $cardBody     .= '</div>
                                        <div class="col-md-6">
                                            <div class="right_about_img" id="left_about_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                         <div class="col-md-6">
                                                <label for="contact-title" class="card-title">' . __('About Image Phone Number') . '</label>
                                                <input type="text" name="about_image_phone" id="contact-title" class=""  value="' . ($item ? clean($item->about_image_phone) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_page_right_about'
        ];
    }

    public function about_feature($page)
    {
        $settingsPage = $page;
        $about_feature = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_FEATURE)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="about">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_FEATURE . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">

                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($about_feature ? ($about_feature->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($about_feature ? ($about_feature->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($about_feature ? clean($about_feature->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($about_feature ? clean($about_feature->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="10" >' . ($about_feature ? clean($about_feature->description) : '') . '</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of feature shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($about_feature ? clean($about_feature->number_of_content) : '') . '">
                                    </div>
                                    <p class="mb-1 text-left">About section feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="feature-about-img" id="feature-about-img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($about_feature && $about_feature->bg_img) {
            $cardBody .= imageShow($about_feature->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $about_feature->id, 'bg_img');
        }
        $cardBody .= '</div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_ABOUT_FEATURE
        ];
    }

    public function about_attorney($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_ATTORNEY)->first();
        $input = '<input type="hidden" name="page" value="about">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_ATTORNEY . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-3 mx-auto">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                                    <td>
                                                        <label class="switch">
                                                            <input type="checkbox" class="content-show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '  name="show">
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="row ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                                <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($item ? clean($item->sub_title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                                <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($item ? clean($item->description) : '') . '</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Teams will be shown') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_page_about_attorney'
        ];
    }

    public function about_award($page)
    {
        $settingsPage = $page;
        $about_award = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_AWARD)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                  <input type="hidden" name="page" value="about">
                  <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_AWARD . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($about_award ? ($about_award->show ? 'checked' : '') : '') . ' />
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($about_award ? ($about_award->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title:') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($about_award ? clean($about_award->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title:') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($about_award ? clean($about_award->sub_title) : '') . '">
                                    </div>

                                     <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Youtube URL:') . '</label>
                                        <input type="text" name="youtube_url" id="right-about-subtitle" class="form-control"  value="' . ($about_award ? clean($about_award->youtube_url) : '') . '">
                                    </div>
                                    <p class="mb-1 text-left">Feature image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="about-page-award-fnt-img" id="home-page-award-fnt-img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($about_award && $about_award->fnt_img) {
            $cardBody .= imageShow($about_award->fnt_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $about_award->id, 'fnt_img');
        }


        $cardBody .= '</div>
                                <div class="col-6">
                                <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description:') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="9" >' . ($about_award ? clean($about_award->description) : '') . '</textarea>
                                    </div>

                                <p class="mb-1 text-left">Background image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="about-page-award-bg-img" id="home-page-award-bg-img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($about_award && $about_award->bg_img) {
            $cardBody .= imageShow($about_award->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $about_award->id, 'bg_img');
        }
        $cardBody .= '</div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($about_award ? ($about_award->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_page_award'
        ];
    }

    public function about_testimonial($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_TESTIMONIAL)->first();
        $input = '<input type="hidden" name="page" value="about">
                                <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_TESTIMONIAL . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-3 mx-auto">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                                    <td>
                                                        <label class="switch">
                                                            <input type="checkbox" class="content-show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '  name="show">
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="row ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_page_about_attorney'
        ];
    }
    public function about_blog($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_ABOUT_BLOG)->first();
        $input = '<input type="hidden" name="page" value="about">
                                <input type="hidden" name="group" value="' . PAGE_GROUP_ABOUT_BLOG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-3 mx-auto">
                                            <table class="table">
                                                <tbody>
                                                <tr>
                                                    <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                                    <td>
                                                        <label class="switch">
                                                            <input type="checkbox" class="content-show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '  name="show">
                                                            <span class="slider round"></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="row ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                             <div class="form-group">
                                                <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                                <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($item ? clean($item->sub_title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                                <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($item ? clean($item->description) : '') . '</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Blog will be shown') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer ' . ($item ? ($item->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'about_page_about_attorney'
        ];
    }

    // testimonial page section inputs
    public function testimonial_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_TESTIMONIAL_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="testimonial">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_TESTIMONIAL_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }

        $cardBody      .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Testimonials will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'testimonial_breadcumb_bg_img'
        ];
    }
    public function testimonial_promotional($page)
    {
        $settingsPage = $page;
        $promotional = $settingsPage->sections()->where('name', PAGE_GROUP_TESTIMONIAL_PROMOTIONAL)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                     <input type="hidden" name="page" value="testimonial">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_TESTIMONIAL_PROMOTIONAL . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">

                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($promotional ? ($promotional->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($promotional ? ($promotional->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($promotional ? clean($promotional->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                        <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->sub_title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                        <textarea name="description" id="right-about-description" class="form-control" rows="10" >' . ($promotional ? clean($promotional->description) : '') . '</textarea>
                                    </div>
                                   <div class="row">
                                       <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 1:') . '</label>
                                            <input type="text" name="btn_1" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_1) : '') . '">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 2:') . '</label>
                                            <input type="text" name="btn_2" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_2) : '') . '">
                                        </div>
                                    </div>
                                     <div class="row">
                                       <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 1 URL:') . '</label>
                                            <input type="text" name="btn_1_url" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_1_url) : '') . '">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="right-about-subtitle" class="card-title">' . __('Button Text 2 URL:') . '</label>
                                            <input type="text" name="btn_2_url" id="right-about-subtitle" class="form-control"  value="' . ($promotional ? clean($promotional->btn_2_url) : '') . '">
                                        </div>
                                    </div>

                                    <p class="mb-1 text-left">About section background image: <code>This image will show home about section\'s left side</code></p>
                                    <div class="testimonial_promotional_img" id="testimonial_promotional_img">
                                        <div class="input-images"></div>
                                    </div>';
        if ($promotional && $promotional->bg_img) {
            $cardBody .= imageShow($promotional->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $promotional->id, 'bg_img');
        }

        $cardBody .= '</div>
                        </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'testimonial_promotional'
        ];
    }
    // hotel page section inputs
    public function hotels_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $section = $settingsPage->sections()->where('name', PAGE_SECTION_HOTEL_BREADCUMB)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="hotels">
                        <input type="hidden" name="group" value="hotels_breadcumb_bg_img">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($section && $section->bg_img) {
            $cardBody .= imageShow($section->bg_img, 'Image', 'img-thumbnail w-50 mt-4', '', 'App\Models\PageSectionSettings', $section->id, 'bg_img');
        }
        $cardBody .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($settingsPage->sections()->where('name', 'hotels_breadcumb_bg_img')->first() ? clean($settingsPage->sections()->where('name', 'hotels_breadcumb_bg_img')->first()->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Hotels will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($settingsPage->sections()->where('name', 'hotels_breadcumb_bg_img')->first() ? clean($settingsPage->sections()->where('name', 'hotels_breadcumb_bg_img')->first()->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'hotels_breadcumb_bg_img'
        ];
    }
    public function hotel_client_say($page)
    {
        $settingsPage = $page;
        $hotel_client_say = $settingsPage->sections()->where('name', PAGE_GROUP_HOTEL_CLIENT_SAY)->first();
        $input = '<input type="hidden" name="page" value="hotels">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_HOTEL_CLIENT_SAY . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($hotel_client_say ? ($hotel_client_say->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($hotel_client_say ? ($hotel_client_say->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($hotel_client_say ? clean($hotel_client_say->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of Testimonial shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($hotel_client_say ? clean($hotel_client_say->number_of_content) : '') . '">
                                    </div>

                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($hotel_client_say ? ($hotel_client_say->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'hotel_client_say'
        ];
    }
    // blogs page section inputs
    public function blogs_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="blogs">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_BLOGS_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . '&nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';

        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody      .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Blogs will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'blogs_breadcumb_bg_img'
        ];
    }

    // teams page section inputs
    public function teams_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="teams">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';

        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody      .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Members will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_TEAMS_BREADCUMB_BG_IMG
        ];
    }

    // faq page section inputs
    public function faq_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_FAQ_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="faq">
                        <input type="hidden" name="group" value="faq_breadcumb_bg_img">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6">
                                                <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                                <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                    <div class="input-images"></div>
                                                </div>
                                        </div>
                                        <div class="col-md-6 text-center">';

        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody      .= '</div>

                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of FAQ will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_FAQ_BREADCUMB_BG_IMG
        ];
    }

    // client dashboard section inputs
    public function client_dashboard_breadcumb_bg_img($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_CLIENT_DASHBOARD_BREADCUMB_BG_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="client_dashboard">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_CLIENT_DASHBOARD_BREADCUMB_BG_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6">
                                                <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                                <div class="breadcumb-bg-img" id="breadcumb_bg_img">
                                                    <div class="input-images"></div>
                                                </div>
                                        </div>
                                        <div class="col-md-6 text-center">';

        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody      .= '</div>

                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_CLIENT_DASHBOARD_BREADCUMB_BG_IMG
        ];
    }

    public function packages_page($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_PACKAGES_PAGE)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="packages">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PACKAGES_PAGE . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">

                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="event-page-breadcumb-bg-img" id="breadcumb_bg_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';

        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-25 mt-5 border', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }
        $cardBody      .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="col-md-12 form-group">
                                                <label for="number_of_attorney" class="card-title">' . __('Number Of Packages will be shown in a page') . '</label>
                                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($item ? clean($item->number_of_content) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_PACKAGES_PAGE
        ];
    }
    public function left_package($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_LEFT_PACKAGE)->first();
        $input = ' <input type="hidden" name="page" value="packages">
                            <input type="hidden" name="group" value="' . PAGE_GROUP_LEFT_PACKAGE . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                                <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($item ? clean($item->sub_title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                                <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($item ? clean($item->description) : '') . '</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';

        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => 'left_package'
        ];
    }
    public function right_package_img($page)
    {
        $settingsPage = $page;
        $right_packag_img = $settingsPage->sections()->where('name', PAGE_GROUP_RIGHT_PACKAGE_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="packages">
                            <input type="hidden" name="group" value="' . PAGE_GROUP_RIGHT_PACKAGE_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6 text-center">';
        if ($right_packag_img && $right_packag_img->fnt_img) {
            $cardBody .= imageShow($right_packag_img->fnt_img, 'Image', 'img-thumbnail w-50', 'width="80" height="80"', 'App\Models\PageSectionSettings', $right_packag_img->id, 'fnt_img');
        }
        $cardBody .= '</div>
                                        <div class="col-md-6">
                                            <div class="right_package_img" id="right_package_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                         <div class="col-md-12">
                                                <label for="contact-title" class="card-title">' . __('About Image Phone Number') . '</label>
                                                <input type="text" name="about_image_phone" id="contact-title" class="form-control"  value="' . ($right_packag_img->first() ? clean($right_packag_img->about_image_phone) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_RIGHT_PACKAGE_IMG
        ];
    }
    public function package_client_say($page)
    {
        $settingsPage = $page;
        $package_client_say = $settingsPage->sections()->where('name', PAGE_GROUP_PACKAGE_CLIENT_SAY)->first();
        $input = ' <input type="hidden" name="page" value="packages">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PACKAGE_CLIENT_SAY . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($package_client_say ? ($package_client_say->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($package_client_say ? ($package_client_say->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($package_client_say ? clean($package_client_say->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of Testimonial shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($package_client_say ? clean($package_client_say->number_of_content) : '') . '">
                                    </div>

                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($package_client_say ? ($package_client_say->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_PACKAGE_CLIENT_SAY
        ];
    }


    public function places_page($page)
    {
        $settingsPage = $page;
        $place_page = $settingsPage->sections()->where('name', PAGE_GROUP_PLACES_PAGE)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="places">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PLACES_PAGE . '">';
        $cardBody = '<div class="card-body text-black">
                        <div class="row">
                            <div class="col-md-6">
                                <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                <div class="gallery-page-breadcumb-bg-img" id="breadcumb_bg_img">
                                    <div class="input-images"></div>
                                </div>
                            </div>
                            <div class="col-md-6 text-center">
                                <div class="form-group">';
        if ($place_page && $place_page->bg_img) {
            $cardBody .= imageShow($place_page->bg_img, '', 'img-thumbnail w-50 mt-4', '', 'App\Models\PageSectionSettings', $place_page->id, 'bg_img');
        }
        $cardBody .= '</div>
                            </div>
                            <div class="col-md-12 form-group">
                                <label for="number_of_attorney" class="card-title">' . __('Number Of Galleries will be shown in a page') . '</label>
                                <input type="number" name="number_of_content" id="number_of_attorney" class="form-control"  value="' . ($place_page ? clean($place_page->number_of_content) : '') . '">
                            </div>
                        </div>
                    </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_PLACES_PAGE
        ];
    }
    public function left_place($page)
    {
        $settingsPage = $page;
        $left_place = $settingsPage->sections()->where('name', PAGE_GROUP_LEFT_PLACE)->first();
        $input = '  <input type="hidden" name="page" value="places">
                                <input type="hidden" name="group" value="' . PAGE_GROUP_LEFT_PLACE . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($left_place ? clean($left_place->title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-subtitle" class="card-title">' . __('Sub-title') . '</label>
                                                <input type="text" name="sub_title" id="right-about-subtitle" class="form-control"  value="' . ($left_place ? clean($left_place->sub_title) : '') . '">
                                            </div>
                                            <div class="form-group">
                                                <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                                <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($left_place ? clean($left_place->description) : '') . '</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';

        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_LEFT_PLACE
        ];
    }
    public function right_place_img($page)
    {
        $settingsPage = $page;
        $right_place_img = $settingsPage->sections()->where('name', PAGE_GROUP_RIGHT_PLACE_IMG)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                     <input type="hidden" name="page" value="places">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_RIGHT_PLACE_IMG . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6 text-center">';
        if ($right_place_img && $right_place_img->fnt_img) {
            $cardBody .= imageShow($right_place_img->fnt_img, 'Image', 'img-thumbnail w-50', 'width="80" height="80"', 'App\Models\PageSectionSettings', $right_place_img->id, 'fnt_img');
        }
        $cardBody .= '</div>
                                        <div class="col-md-6">
                                            <div class="right_place_img" id="right_place_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                         <div class="col-md-12">
                                                <label for="contact-title" class="card-title">' . __('About Image Phone Number') . '</label>
                                                <input type="text" name="about_image_phone" id="contact-title" class="form-control"  value="' . ($right_place_img ? clean($right_place_img->about_image_phone) : '') . '">
                                            </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_RIGHT_PLACE_IMG
        ];
    }
    public function place_client_say($page)
    {
        $settingsPage = $page;
        $place_client_say = $settingsPage->sections()->where('name', PAGE_GROUP_PLACE_CLIENT_SAY)->first();
        $input = '  <input type="hidden" name="page" value="places">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_PLACE_CLIENT_SAY . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" class="content-show" name="show" ' . ($place_client_say ? ($place_client_say->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row ' . ($place_client_say ? ($place_client_say->show ? '' : 'd-none') : 'd-none') . '">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                        <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($place_client_say ? clean($place_client_say->title) : '') . '">
                                    </div>
                                    <div class="form-group">
                                        <label for="number-case-study" class="card-title">' . __('Number of Testimonial shown?') . '</label>
                                        <input type="number" name="number_of_content" class="form-control"  value="' . ($place_client_say ? clean($place_client_say->number_of_content) : '') . '">
                                    </div>

                                </div>
                            </div>
                        </div>';
        $cardFooter = '<div class="card-footer ' . ($place_client_say ? ($place_client_say->show ? '' : 'd-none') : 'd-none') . '">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_PLACE_CLIENT_SAY
        ];
    }

    public function error_404_page($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_ERROR_GORUP_404)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_ERROR . '">
                        <input type="hidden" name="group" value="' . PAGE_ERROR_GORUP_404 . '">';
        $cardBody = '<div class="card-body text-black">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="bg_image_404">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-50 mt-4', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }

        $cardBody .= '</div>
                                        <div class="col-md-12 form-group">
                                                <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                                <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                            </div>
                                        <div class="col-md-12 form-group">
                                            <label for="right-about-description" class="card-title">' . __('Description') . '</label>
                                            <textarea name="description" id="right-about-description" class="form-control" rows="5" >' . ($item ? clean($item->description) : '') . '</textarea>
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="right-about-description" class="card-title">' . __('Btn Title') . '</label>
                                            <input type="text" name="btn_title" class="form-control" value="' . ($item ? clean($item->btn_title) : '') . '" />
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_ERROR_GORUP_404
        ];
    }

    public function auth_login_page($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_AUTH_LOGIN)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_AUTH . '">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_AUTH_LOGIN . '">';
        $cardBody = '<div class="card-body text-black">
                            <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show Form') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" name="show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="auth_login_img" id="auth_login_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-50 mt-4', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }

        $cardBody .= '</div>
                                        <div class="col-md-12 form-group">
                                            <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                            <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="right-about-description" class="card-title">' . __('Btn Title') . '</label>
                                            <input type="text" name="btn_title" class="form-control" value="' . ($item ? clean($item->btn_title) : '') . '" />
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_AUTH_LOGIN
        ];
    }

    public function auth_register_page($page)
    {
        $settingsPage = $page;
        $item = $settingsPage->sections()->where('name', PAGE_GROUP_AUTH_REGISTER)->first();
        $input = '<input type="hidden" name="_token" value="' . @csrf_token() . '">
                    <input type="hidden" name="page" value="' . PAGE_AUTH . '">
                        <input type="hidden" name="group" value="' . PAGE_GROUP_AUTH_REGISTER . '">';
        $cardBody = '<div class="card-body text-black">
                        <div class="row">
                                <div class="col-3 mx-auto">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td class="text-right font-weight-bold">' . __('Show Form') . '</td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox" name="show" ' . ($item ? ($item->show ? 'checked' : '') : '') . '>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p class="card-title">' . __('Breadcamb Background Image') . ' &nbsp;<code>Acceptable image size 1920 x 1200 pixel</code></p>
                                            <div class="auth_register_img" id="auth_register_img">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-center">';
        if ($item && $item->bg_img) {
            $cardBody .= imageShow($item->bg_img, 'Image', 'img-thumbnail w-50 mt-4', '', 'App\Models\PageSectionSettings', $item->id, 'bg_img');
        }

        $cardBody .= '</div>
                                        <div class="col-md-12 form-group">
                                            <label for="contact-title" class="card-title">' . __('Title') . '</label>
                                            <input type="text" name="title" id="contact-title" class="form-control"  value="' . ($item ? clean($item->title) : '') . '">
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for="right-about-description" class="card-title">' . __('Btn Title') . '</label>
                                            <input type="text" name="btn_title" class="form-control" value="' . ($item ? clean($item->btn_title) : '') . '" />
                                        </div>
                                    </div>
                                </div>';
        $cardFooter = '<div class="card-footer">
                            <button type="submit" class="btn btn-danger btn-lg rounded">' . __('Save') . '</button>
                        </div>';
        $output = $input . $cardBody . $cardFooter;
        return (object)[
            'html' => $output,
            'section' => PAGE_GROUP_AUTH_REGISTER
        ];
    }
}
