<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PageSectionSettings extends Model
{
    use HasFactory;

    protected $fillable = ['page_id', 'name', 'number_of_content', 'bg_img', 'title', 'sub_title', 'description', 'fnt_img', 'show', 'form_title', 'form_subtitle', 'line_one', 'line_two', 'case_won', 'total_case', 'total_donation', 'total_volunteer', 'slider_package_discount', 'btn_title', 'btn_url', 'phone_number', 'about_image_phone', 'youtube_url', 'btn_1', 'btn_2', 'btn_1_url', 'btn_2_url', 'testimonial_id'];

    public function getBgImgAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_SETTINGS . $value)) && $value) ? asset(UPLOAD_FOLDER_SETTINGS . $value) : '');
    }

    public function getFntImgAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_SETTINGS . $value)) && $value) ? asset(UPLOAD_FOLDER_SETTINGS . $value) : '');
    }

    public function page()
    {
        return $this->belongsTo(PageSettings::class, 'page_id', 'id');
    }
}
