<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;
    protected $fillable = ['method_type', 'account', 'api_id', 'client_id', 'secret_key', 'logo'];
    protected $guarded = ['id', 'secret_key'];
    protected $hidden = ['secret_key', 'api_id', 'client_id'];

    public function getLogoAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_PAYMENT_METHOD_LOGO . $value)) && $value) ? asset(UPLOAD_FOLDER_PAYMENT_METHOD_LOGO . $value) : '');
    }
}
