<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Place extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'place_primary_image'];

    public function getPlacePrimaryImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_PLACES . $value)) && $value) ? asset(UPLOAD_FOLDER_PLACES . $value) : '');
    }

    public function package()
    {
        return $this->hasMany(Package::class, 'place_id', 'id')
            ->with(['category', 'images', 'subPrice', 'departure', 'discount']);
    }
}
