<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'designation', 'testimonial', 'image', 'status', 'rating', 'video_link'];

    public function getImageAttribute($value)
    {
        return ((file_exists(public_path(UPLOAD_FOLDER_TESTIMONIAL . $value)) && $value) ? asset(UPLOAD_FOLDER_TESTIMONIAL . $value) : '');
    }
}
