<?php

namespace App\Services;

use App\Models\Blog;

class BlogServices
{
    public $item;

    public function __construct()
    {
        $this->item = Blog::query()->with(['category','blogTags','userId','comment']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id'=>$id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id'=>$id])->update($data);
    }

    public function destroy($id)
    {
        return $this->item->where(['id'=>$id])->delete();
    }
}
