<?php

namespace App\Services;

use App\Models\Country;

class CountryService
{
    public $item;

    public function __construct()
    {
        $this->item = Country::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id'=>$id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->findById($id)->update($data);
    }

    public function destroy($id)
    {
        return $this->findById($id)->delete();
    }
}
