<?php

namespace App\Services;

use App\Models\Facility;

class FacilityService
{
    public $item;

    public function __construct()
    {
        $this->item = Facility::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->findById($id)->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);
        destroryFile(UPLOAD_FOLDER_FACIlITY, $item->getAttributes()['icon']);

        return $item->delete();
    }
}
