<?php

namespace App\Services;

use App\Models\HotelAccommodation;

class HotelAccommodationService
{
    public $item;
    protected $room_images_path = UPLOAD_FOLDER_HOTEL_ACCOMMODATION;

    public function __construct()
    {
        $this->item = HotelAccommodation::query()->with(['accommodation', 'hotel']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        if ($data['room_images']) {
            $room_images = fileUpload($data['room_images'], $this->room_images_path);
            $data['room_images'] = json_encode($room_images);
        }
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        $hotel_accommodation = $this->findById($id);

        if ($data['room_images']) {
            $room_images = fileUpload($data['room_images'], $this->room_images_path);
            $exits_room_images = (($hotel_accommodation->room_images) ? json_decode($hotel_accommodation->room_images, true) : []);
            $data['room_images'] = json_encode(array_merge($room_images, $exits_room_images));
        }

        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);
        $room_images = json_decode($item->room_images);

        if (count($room_images)) {
            foreach ($room_images as $room_image) {
                destroryFile($this->room_images_path, $room_image);
            }
        }
        return $item->delete();
    }
}
