<?php

namespace App\Services;

use App\Models\HotelBooking;

class HotelBookingService
{
    public $item;

    public function __construct()
    {
        $this->item = HotelBooking::with(['hotel', 'hotelAccommodation', 'discount', 'user']);
    }

    function mailSend($email, $subject, $message)
    {
        $mail_data = ['to' => $email, 'subject' => $subject, 'message' => $message];
        mailFunc($mail_data);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        $item = $this->item->create($data);
        $item = $this->findById($item->id);

        $discount = $item->discount;
        $hotel_accommdation = $item->hotelAccommodation;
        $price_cal = discountPriceCalculate($hotel_accommdation->price, $discount, false);
        $data['amount'] = $hotel_accommdation->price;
        $data['discount_amount'] = $price_cal['discount'];
        $data['net_amount'] = $price_cal['price'];
        $item->update($data);

        // mail
        $subject = 'Booking reserve, Please confirm with this link';
        $accommodation = $item->hotelAccommodation;
        $message = 'Hello, ' . $item->first_name . ' ' . $item->last_name . '<br>' . 'Your reservation is done.<br>';
        $message .= '<b>Hotel: </b>' . $item->hotel->hotel_name . '<br>';
        $message .= '<b>Accommodation: </b>' . $accommodation->accommodation->name . '<br>';
        $message .= '<b>Accommodation Price: </b>' . currencyFormat($item->net_amount) . '<br>';
        $message .= '<b>Check In: </b>' . date('Y-m-d h:i A', strtotime($item->check_in)) . '<br>';
        $message .= '<b>Check Out: </b>' . date('Y-m-d h:i A', strtotime($item->check_out)) . '<br>';
        $message .= '<b>Arrival Time: </b>' . date('Y-m-d h:i A', strtotime($item->arrival_date_time)) . '<br>';
        $message .= '<b>Please confirm your reservation with this link </b> <a href="' . route('confirm.booking', ['type' => BOOKING_HOTEL, 'token' => encrypt($item->id), 'email' => $item->email]) . '">Click Here</a><br>';

        $this->mailSend($item->email, $subject, $message);
        return $item;
    }

    public function destroy($id)
    {
        return $this->findById($id)->delete();
    }
}
