<?php

namespace App\Services;

use App\Models\PackageBooking;

class PackageBookingService
{
    public $item;
    public $discount;
    public $group_price;
    public $sub_price;

    public function __construct()
    {
        $this->item = PackageBooking::with(['package', 'packageSubPrice', 'discount', 'user']);
        $this->discount = new DiscountService();
        $this->sub_price = new PackageSubPriceService();
    }

    function mailSend($email, $subject, $message)
    {
        $mail_data = ['to' => $email, 'subject' => $subject, 'message' => $message];
        mailFunc($mail_data);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        $item = $this->item->create($data);
        $item = $this->findById($item->id);
        $discount = $item->discount;
        $package_sub_price = $item->packageSubPrice;
        $price_cal = discountPriceCalculate($package_sub_price->tour_price, $discount, false);
        $data['amount'] = $package_sub_price->tour_price;
        $data['discount_amount'] = $price_cal['discount'];
        $data['net_amount'] = $price_cal['price'];
        $item->update($data);

        // mail
        $subject = 'Package Booking reserve, Please confirm with this link';
        $message = 'Hello, ' . $item->first_name . ' ' . $item->last_name . '<br>' . 'Your reservation is done.<br>';
        $message .= '<b>Package: </b>' . $item->package->title . '<br>';
        $message .= '<b>Group Person: </b>' . $package_sub_price->group_size . '<br>';
        $message .= '<b>Group Price: </b>' . currencyFormat($item->amount) . '<br>';
        $message .= '<b>Arrival Time: </b>' . date('Y-m-d h:i A', strtotime($item->arrival_date_time)) . '<br>';
        $message .= '<b>Please confirm your booking with this link </b> <a href="' . route('confirm.booking', ['type' => BOOKING_PACKAGE, 'token' => encrypt($item->id), 'email' => $item->email]) . '">Click Here</a><br>';

        $this->mailSend($item->email, $subject, $message);
        return $item;
    }

    public function destroy($id)
    {

        return $this->findById($id)->delete();
    }
}
