<?php

namespace App\Services;

use App\Models\PackageCategory;

class PackageCategoryService
{
    public $item;

    public function __construct()
    {
        $this->item = PackageCategory::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        $item = $this->item->create($data);
        menuCreate($data['name'], $item->id, PACKAGE_PAGE_TYPE_CATEGORY);
        return $item;
    }

    public function update($data, $id)
    {
        menuCreate($data['name'], $id, PACKAGE_PAGE_TYPE_CATEGORY);
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        return $this->item->where(['id' => $id])->delete();
    }
}
