<?php

namespace App\Services;

use App\Models\PackageImage;

class PackageImageService
{
    public $item;

    public function __construct()
    {
        $this->item = PackageImage::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);
        destroryFile(UPLOAD_FOLDER_PKG_IMAGE, $item->getAttributes()['images']);
        return $item->delete();
    }
}
