<?php

namespace App\Services;

use App\Models\Partners;

class PartnerService
{
    public $item;

    public function __construct()
    {
        $this->item = Partners::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->findById($id)->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);

        if ($item->hotel_gd_image != null) {
            destroryFile(UPLOAD_FOLDER_PARTNERS, $item->getAttributes()['image']);
        }

        return $item->delete();
    }
}
