<?php

namespace App\Services;

use App\Models\PaymentTransaction;
use App\Services\StripeService;

class PaymentTransactionService
{
    public function save($request, $paymentMethod)
    {
        try {
            $paymentMethodId = paymentMethod($paymentMethod)->id;
            $transaction = new PaymentTransaction();
            $transaction->payment_method_id = $paymentMethodId;
            $transaction->payment_method = STRIPE_PAYMENT;
            $transaction->booking_id = $request->bookingId;
            $transaction->booking_type = $request->type;
            $transaction->transaction_id = $request->transactionId;
            $transaction->amount = $request->amount;
            $transaction->save();
            return $transaction;
        } catch (\Throwable $th) {
            //throw $th;
        }
    }
}
