<?php

namespace App\Services;

use App\Models\Attorney;

class TeamServices
{
    public $item;

    public function __construct()
    {
        $this->item = Attorney::query()->with(['designation']);
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        $item = $this->findById($id);
        destroryFile(UPLOAD_FOLDER_ATTORNEYS, $item->getAttributes()['image']);
        return $item->delete();
    }
}
