<?php

namespace App\Services;

use App\Models\Testimonial;

class TestimonialServices
{
    public $item;

    public function __construct()
    {
        $this->item = Testimonial::query();
    }

    public function getData()
    {
        return $this->item;
    }

    public function findById($id)
    {
        return $this->item->where(['id' => $id])->first();
    }

    public function store($data)
    {
        return $this->item->create($data);
    }

    public function update($data, $id)
    {
        return $this->item->where(['id' => $id])->update($data);
    }

    public function destroy($id)
    {
        $testimonial = $this->findById($id);
        if ($testimonial->image != null) {
            // delete existing image
            $file = 'upload/testimonial/' . $testimonial->image;
            if (file_exists(public_path($file))) {
                unlink(public_path($file));
            }
        }

        return $testimonial->delete();
    }
}
