<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotels', function (Blueprint $table) {
            $table->id();
            $table->string('hotel_primary_image');
            $table->string('hotel_name');
            $table->string('hotel_location');
            $table->longText('description');
            $table->double('latitude');
            $table->double('longitude');
            $table->string('breakfast_info');
            $table->string('lunch_info');
            $table->string('dinner_info');
            $table->string('country')->nullable();
            $table->string('city')->nullable();
            $table->enum('parking_info',[ACTIVE_STATUS, DEACTIVE_STATUS]);
            $table->string('hotel_to_stay_title');
            $table->string('phone',20);
            $table->string('email',50);
            $table->string('website',50)->nullable();
            $table->longText('hotel_to_stay_description');
            $table->longText('facilities');
            $table->longText('rules');
            $table->enum('status',[ACTIVE_STATUS,DEACTIVE_STATUS])->comment('1=Active 2=Deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotels');
    }
}
