<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelAccommodationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_accommodations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id');
            $table->unsignedBigInteger('accommodation_id');
            $table->double('price');
            $table->tinyInteger('no_of_room');
            $table->integer('no_of_adult');
            $table->integer('no_of_children');
            $table->double('room_size');
            $table->json('facilities');
            $table->json('room_images')->nullable();
            $table->enum('is_smoking',[ACTIVE_STATUS, DEACTIVE_STATUS]);
            $table->timestamps();
            $table->foreign('hotel_id')->references('id')->on('hotels');
            $table->foreign('accommodation_id')->references('id')->on('accommodations');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_accommodations');
    }
}
