<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackageBookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('package_bookings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('package_id');
            $table->unsignedBigInteger('package_sub_price_id');
            $table->unsignedBigInteger('discount_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->dateTime('arrival_date_time');
            $table->string('first_name');
            $table->string('last_name');
            $table->double('amount');
            $table->string('email');
            $table->tinyInteger('rating');
            $table->enum('status',[BOOKING_STATUS_PENDING,BOOKING_STATUS_REVIEW,BOOKING_STATUS_APPROVED,BOOKING_STATUS_CONFIRM])->comment('1=Panding, 2=review, 3=approved, 4=confirm ');
            $table->foreign('package_id')->references('id')->on('packages');
            $table->foreign('package_sub_price_id')->references('id')->on('package_sub_prices');
            $table->foreign('discount_id')->references('id')->on('discounts');
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('package_bookings');
    }
}
